;								EJEMPLO 27
;						Autor: Mikel Etxebarria
;			(c) Ingeniera de Microsistemas Programados S.L.
;						www.microcontroladores.com
;								Bilbao 2006
;
;El TMR2. Generacin de periodos y frecuencias
;
;El TMR2 provoca una interrupcin cada vez que se alcance el valor de un periodo (P). La inte-
;rrupcin hace bascular el estado lgico de la lnea RB0, por lo que la frecuencia en esta 
;lnea ser 1/2P.
;
;El periodo P se establece mediante el valor binario que se introduce a travs de los interrup-
;tores E0-E5 conectados a la puerta A, multiplicado por 4.
;		
		List	p=16F876A		;Tipo de procesador
		include	"P16F876A.INC"	;Definiciones de registros internos

;Ajusta los valores de la palabra de configuracin durante el ensamblaje:
;proteccin de cdigo y datos=OFF, LVP=OFF, WDT=OFF y OSC=XT

			__config _CP_OFF&_CPD_OFF&_LVP_OFF&_WDT_OFF&_XT_OSC

Temporal	equ	0x20			;Variable temporal de propsito general
Copia		equ	0x21			;Estado de RA5-RA0
Contador	equ	0x21			;Variable de temporizacin

			org	0x00			;Vector de RESET	
			goto	Inicio
			org	0x04			;Vector de interrupcin
			goto	Inter
			org	0x05

;Programa de tratamiento de la interrupcin que provoca el TMR2 cada vez que se alcanza el
;valor de un periodo

Inter		decfsz	Contador,F	;Se ha repetido 10 veces ??
			goto	Inter_Fin_1	;No
			movf	PORTA,W		;Si
			subwf	Copia,W
			btfsc	STATUS,Z	;Ha habido cambio de estado en RA5-RA0 ??
			goto	Inter_Fin	;No, el periodo sigue siendo el mismo
			movf	PORTA,W		;Si, hay que actualizar el registro de periodos
			movwf	Copia
			movwf	Temporal	;Leer el nuevo estado de RA5-RA0
			bcf		STATUS,C	
			rlf		Temporal,F
			rlf		Temporal,W	;Multiplica por 4
			bsf		STATUS,RP0	;Selecciona pgina 1
			movwf	PR2			;Ajusta nuevo periodo
			bcf		STATUS,RP0	;Selecciona pgina 0
Inter_Fin	movlw	.10
			movwf	Contador	;Restaura el contador
			movlw	0x01
			xorwf	PORTB,F		;RB0 cambia de estado
Inter_Fin_1	bcf		PIR1,TMR2IF	;Repone el flag del TMR2
			retfie


;Programa principal

Inicio		clrf	PORTB		;Desconecta salidas
			clrf	PORTA
			bsf		STATUS,RP0	;Selecciona banco 1
			movlw	b'00000110'
			movwf	ADCON1		;Puerta A E/S digitales
			clrf	TRISB		;Puerta B se configura como salida
			movlw	b'00111111'
			movwf	TRISA		;RA5-RA0 entradas
			bsf		PIE1,TMR2IE	;Habilita interrupcin del TMR2	
			bcf		STATUS,RP0	;Selecciona banco 0

;El TMR2 emplea un preescaler y un postcaler de 1:16 (total 1:256). Trabajando a una
;frecuencia de 4 MHZ el TMR2 evoluciona cada 16uS (preescaler 1:16). La cuenta avanza hasta
;alcanzar el valor del registro de periodos que se carga con el estado de ((RA5-RA0) * 4), por 16
;(postscaler 1:16). Dicho tiempo escilar entre 256 uS y 65535 uS. Todo ello se repite 10 veces antes de
;que RB0 cambie de estado. En esta lnea tenemos un semi periodo comprendido entre 2,5mS y 655 mS
		
			movf	PORTA,W
			movwf	Copia		
			movwf	Temporal	;Lee el estado de RA5-RA3
			bcf		STATUS,C
			rlf		Temporal,F
			rlf		Temporal,W	;Multiplica por 4
			bsf		STATUS,RP0	;Selecciona el banco 1
			movwf	PR2			;Ajusta el registro de periodos
			bcf		STATUS,RP0	;Selecciona el banco 1
			movlw	b'01111110'
			movwf	T2CON		;TMR2 On, preescaler/postcaler = 1:16
			clrf	TMR2		;Inicia el TMR2
			movlw	.10
			movwf	Contador	;Carga el contador de interrupciones
			movlw	b'11000000'
			movwf	INTCON		;Habilita interrupciones

Loop		nop
			goto	Loop		;Bucle infinito		

			end					;Fin del programa fuente
